package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.kyleduo.switchbutton.SwitchButton;
import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.utils.Constants;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

/**
 * @author syb
 * @date 2022/8/30 10:11
 * OTG/HOST switching function
 */
public class OtgActivity extends BaseActivity implements View.OnClickListener {
    private SwitchButton btnOtg;
    private SwitchButton btnHost;
    private TextView btnRead;
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_otg);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);
        btnRead = findViewById(R.id.btn_read);
        btnOtg = findViewById(R.id.btn_otg);
        btnHost = findViewById(R.id.btn_host);
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
    }

    @Override
    protected void setTitle() {
        setActionBarTitle("OTG/HOST switching function");
    }

    @Override
    protected void setListener() {
        btnOtg.setOnClickListener(v -> {
            btnHost.setChecked(!btnOtg.isChecked());
            if (btnOtg.isChecked()) {
                btnRead.setText("Current mode: otg");
                otg();
            } else {
                btnRead.setText("Current mode: host");
                host();
            }
        });

        btnHost.setOnClickListener(v -> {
            btnOtg.setChecked(!btnHost.isChecked());
            if (btnHost.isChecked()) {
                btnRead.setText("Current mode: host");
                host();
            } else {
                btnRead.setText("Current mode: otg");
                otg();
            }
        });

        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    public void host() {
        byte[] host = {'h', 'o', 's', 't'};
        FileOutputStream fBlue = null;
        try {
            fBlue = new FileOutputStream("/sys/devices/platform/fe8a0000.usb2-phy/otg_mode");
            fBlue.write(host);
            fBlue.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void otg() {
        byte[] otg = {'o', 't', 'g'};
        FileOutputStream fBlue = null;
        try {
            fBlue = new FileOutputStream("/sys/devices/platform/fe8a0000.usb2-phy/otg_mode");
            fBlue.write(otg);
            fBlue.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readInStream() {
        try {
            String path = "/sys/devices/platform/fe8a0000.usb2-phy/otg_mode";
            File file = new File(path);
            FileInputStream inStream = null;
            inStream = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int len = 0;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            byte[] data = outStream.toByteArray();
            outStream.close();
            inStream.close();
            return new String(data);
        } catch (Exception e) {
            e.printStackTrace();
            Log.e("readInStream", e.getMessage());
        }
        return "";
    }

    @Override
    protected void onResume() {
        super.onResume();
        String readModel = readInStream();
        if (readModel.contains("otg")) {
            btnOtg.setChecked(true);
        } else {
            btnHost.setChecked(true);
        }

        try {
            btnRead.setText("current mode：" + readModel);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
